/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GScanAnalysis                                                         *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation of a scan analysis                                         *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GScanAnalysis
#define Gfitter_GScanAnalysis

#include "Gfitter/GObject.h"

class TString;

namespace Gfitter {

   class GParameter;
   class GScanAnalysis;
   std::ostream& operator << ( std::ostream& os, const GScanAnalysis& scan );

   class GScanAnalysis : public GObject {

   public:

      GScanAnalysis();
      ~GScanAnalysis();

      // execute the toy test and return p-value
      void ExecuteScan( const TString& par, Int_t nbins );
      void ExecuteScan( GParameter* gpar );

   private:

   };
}

#endif
