/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GSimulatedAnnealing                                                   *
 *                                                                                *
 * Description:                                                                   *
 *      Fit wrapper for TMVA Simuated Annealing Algorithm                         *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GSimulatedAnnealing
#define Gfitter_GSimulatedAnnealing

#include "Gfitter/GFitterBase.h"
#include "TMVA/IFitterTarget.h"
#include "TMVA/Interval.h"
#include "TMVA/SimulatedAnnealing.h"

namespace Gfitter {

   class GStore;

   class GSimulatedAnnealing : public GFitterBase, TMVA::IFitterTarget {
      
   public:
      
      GSimulatedAnnealing(); // default constructor
      virtual ~GSimulatedAnnealing();

      // initialise fitter
      void     Initialise();

      // perform fit, and return minimum chi-squared
      Double_t ExecuteFit();
      Double_t GetCurrentChi2();

		void UpdateResults();

      // scan 2D contour
      void DrawContour( GParameter* gpar1, GParameter* gpar2, 
                        Int_t npoints, Double_t dchi2, Double_t* npx, Double_t* npy );

      // interface to FCN in GFitterBase
      Double_t EstimatorFunction( std::vector<Double_t> & factors ); 

      // read the configuration parameters from GStore
      void ReadSAConfiguration(); 

      // print the configuration parameters
      void PrintSAConfiguration(); 

   protected:

   private:

      static GSimulatedAnnealing*  GetThisPtr();
      static GSimulatedAnnealing*  m_This;
      
      TMVA::SimulatedAnnealing* m_sa;

      vector<TMVA::Interval*> m_ranges;        
      
      // Configuration parameters
      Int_t    m_maxcalls;
      Double_t m_initialtemperature;
      Double_t m_mintemperature;
      Double_t m_eps;
      TString  m_kerneltemperature;
      Double_t m_temperaturescale;
      Double_t m_adaptivespeed;
      Double_t m_temperatureadaptivestep;
      Bool_t   m_usedefaultscale;
      Bool_t   m_usedefaulttemperature;

   };   

}

#endif
