/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GTheory                                                               *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/

#include <iostream>
#include "Gfitter/GTheory.h"
#include "Gfitter/GTheoryRef.h"
#include "Gfitter/GStore.h"
#include "Gfitter/GParameter.h"
#include "Gfitter/GParameterRef.h"

ClassImp(Gfitter::GTheory)

Gfitter::GTheory::GTheory() 
  : Gfitter::GTheoryBase(),
    m_currentValue( 1e23 )
{
   InitClassName( "GTheory" );
}
   
// constructor for simple formula parser
Gfitter::GTheory::GTheory( const TString& /* name */, const TString& /* formula */ )
   : Gfitter::GTheoryBase(),
     m_currentValue( 1e23 )
{
   InitClassName( "GTheory" );
}
   
Gfitter::GTheory::~GTheory() {}

Double_t Gfitter::GTheory::GetPrediction() 
{
   //   m_logger << kINFO << "Inside GetPrediction" << GEndl;
   //   m_logger << kINFO << "UseParCaching: " << UseParCaching() 
   //            << " IsUpToDate: " << IsUpToDate() << GEndl;
   if (UseParCaching() && IsUpToDate()) return m_currentValue;

   m_currentValue = GetTheoryPrediction();
   NotifyReferencesOfChange();
   SetUpToDate();

   return m_currentValue;
}

std::ostream& Gfitter::operator << ( std::ostream& os, const Gfitter::GTheory& theory ) 
{
   return os << theory;
}
