/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GTheory                                                               *
 *                                                                                *
 * Description:                                                                   *
 *      Abstract base class for theory                                            *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GTheory
#define Gfitter_GTheory

#include <map>
#include "TString.h"
#include "Gfitter/GTheoryBase.h"
#include "Gfitter/GParameterRef.h"
#include "Gfitter/GTheoryRef.h"

namespace Gfitter {

   class GParameter;
   class GTheoryRef;
   class GStore;
   class GTheory;

   std::ostream& operator << ( std::ostream& os, const GTheory& theory );

   class GTheory : public GTheoryBase {
    
   public:
     
      // default constructor
      GTheory();

      // constructor for simple formula parser
      GTheory( const TString& name, const TString& formula );

      // destructor
      virtual ~GTheory();

      // theory prediction as function of parameters stored in GStore
      Double_t GetPrediction();
      operator Double_t() { return GetPrediction(); } // same

   protected:

      // theory prediction as function of parameters stored in GStore
      virtual Double_t GetTheoryPrediction() = 0;

   private:

      void UpdateLocalFlags( GReference& ) {}

      Double_t m_currentValue;

      ClassDef(GTheory,0)
  };
}

#endif
