/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GTheoryRef                                                            *
 *                                                                                *
 * Description:                                                                   *
 *      Parameter container                                                       *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GTheoryRef
#define Gfitter_GTheoryRef

#include "Rtypes.h"
#include "TObject.h"
#include "Gfitter/GReference.h"
#include "Gfitter/GTheoryBase.h"

namespace Gfitter {
   
   class GTheoryRef : public GReference {

   public:
      
      GTheoryRef() 
         : GReference(), m_theory(0) {}
         
      /**@brief destructor*/
      virtual ~GTheoryRef() {}

      // overloading dereferencing operator (both are needed)
      // it is now sort of a smart pointer, no need to change any Theory
      GTheoryBase*  operator->()      { return  m_theory; }
      GTheoryBase&  operator*() const { return *m_theory; } 

      GTheoryBase** GetAddress()      { return &m_theory; }
      void          SetAddress( GTheoryBase *p ) { m_theory = p; }
      
   private:

      GTheoryBase* m_theory;
   };
}

#endif
