/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GToyAnalysis                                                          *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation of a toy analysis                                          *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GToyAnalysis
#define Gfitter_GToyAnalysis

#include "Gfitter/GObject.h"

namespace Gfitter {
   
   class GParameter;
   
   class GToyAnalysis;
   std::ostream& operator << ( std::ostream& os, const GToyAnalysis& scan );

   class GToyAnalysis : public GObject {

   public:

      GToyAnalysis();
      ~GToyAnalysis();

      // execute the toy test and return p-value
      Double_t ExecuteToy( Double_t initial_chi2min, Int_t nToyExp  );

      // one dimensinal toy scan -> result is a CL histogram
      void Scan1DToy( const TString& par, Int_t nbins, Int_t ntoys );
      void Scan1DToy( GParameter* gpar, Int_t nbins, Int_t ntoys );
     
      // two dimensinal toy scan -> result is a CL histogram
      void Scan2DToy( const TString& par1, const TString& par2, Int_t nbinsX, Int_t nbinsY, Int_t ntoys );
      void Scan2DToy( GParameter* gpar1, GParameter* gpar2, Int_t nbinsX, Int_t nbinsY, Int_t ntoys );
      

   private:

   };
}

#endif
