/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GTypes                                                                *
 *                                                                                *
 * Description:                                                                   *
 *      Type definitions                                                          *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GTypes
#define Gfitter_GTypes

#include "TString.h"

namespace Gfitter {

   namespace GTypes {

      enum Particle { kElectron = 1, kMuon, kTau, kNeutrino,
                      kUp, kDown, kCharm, kStrange, kBottom, kTop };
  
      TString GetName(Particle ParticleType);
   }
}

inline TString Gfitter::GTypes::GetName(Particle ParticleType)
{  
   if     ( ParticleType == kElectron ) return "Electron";
   else if( ParticleType == kMuon )     return "Muon";
   else if( ParticleType == kTau )      return "Tau";
   else if( ParticleType == kNeutrino ) return "Neutrino";
   else if( ParticleType == kUp )       return "Up-Quark";
   else if( ParticleType == kDown )     return "Down-Quark";
   else if( ParticleType == kCharm )    return "Charm-Quark";
   else if( ParticleType == kStrange )  return "Strange-Quark";
   else if( ParticleType == kBottom )   return "Bottom-Quark";
   else if( ParticleType == kTop )      return "Top-Quark";
   else return "Wrong Particle Type";
}

#endif

