/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GVariable                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *
 *                                                                                *         
 **********************************************************************************/

#include <sstream>
#include <iostream>

#include "TString.h"

#include "Gfitter/GVariable.h"

using namespace std;

Gfitter::GVariable::GVariable( const TString& name, const TString& value )
   : m_name ( name ),
     m_value( value ),
     m_b( kFALSE ), m_i( 0 ), m_f( 0 ), m_s( "" )
{
   InitClassName( "GVariable" );
   
   stringstream sstr;
   sstr << m_value;
   
   // find type
   sstr >> m_i;
   if (sstr.eof()) m_type = GVariable::Int;
   else {
      sstr >> m_f;
      m_f += m_i;
      if (sstr.eof()) m_type = GVariable::Float;
      else {
         if (m_value == "T" || m_value == "F") {
            m_type = GVariable::Bool;
            m_b    = (m_value == "T") ? kTRUE : kFALSE;
         }
         else {
            m_type = GVariable::String;
            m_s    = m_value;
         }
      }
   }            
}

Gfitter::GVariable::~GVariable()
{}

Bool_t Gfitter::GVariable::GetBoolValue() const
{
   // sanity check
   if (m_type != GVariable::Bool) {
      m_logger << kFATAL << "Variable: \"" << m_name << "\" is not Bool, but: " << m_type << GEndl;
   }
   return m_b;
}

Int_t Gfitter::GVariable::GetIntValue() const
{
   // sanity check
   if (m_type != GVariable::Int) {
      m_logger << kFATAL << "Variable: \"" << m_name << "\" is not Int, but: " << m_type << GEndl;
   }
   return m_i;
}

Float_t Gfitter::GVariable::GetFloatValue() const
{
   // sanity check
   if (m_type != GVariable::Float) {
      m_logger << kFATAL << "Variable: \"" << m_name << "\" is not Float, but: " << m_type << GEndl;
   }
   return m_f;
}

const TString& Gfitter::GVariable::GetStringValue() const
{
   // sanity check
   if (m_type != GVariable::String) {
      m_logger << kFATAL << "Variable: \"" << m_name << "\" is not String, but: " << m_type << GEndl;
   }
   return m_s;
}

ostream& Gfitter::operator << ( ostream& os, const Gfitter::GVariable& variable ) 
{
   os << "\"" << variable.GetVariableName() << "\" : " << variable.GetValue() 
      << " (type: " << variable.GetType() << ")";
   return os;
}
