/**********************************************************************************
 * Project: Gfitter - A ROOT-integrated generic fitting package                   *
 * Package: Gfitter                                                               *
 * Class  : GWorkspace                                                            *
 *                                                                                *
 * Description:                                                                   *
 *      Container for parameter curve                                             *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef Gfitter_GWorkspace
#define Gfitter_GWorkspace

#include "TString.h"
#include "Gfitter/GDataBase.h"

/*
namespace RooStats {
  class ModelConfig;
}
class RooWorkspace;
*/

#include "RooWorkspace.h"
#include "RooStats/ModelConfig.h"
#include "RooAbsReal.h"

namespace Gfitter {
  
  // MG
  class GParameter;
  
  class GWorkspace : public GDataBase {
    
   public:

    GWorkspace();
    GWorkspace( const TString& filename, const TString& workspaceName, const TString& modelconfigstr );
    GWorkspace( const GWorkspace& );  
    virtual ~GWorkspace();
    
    Double_t GetChiSquared() const;
    inline RooWorkspace* GetWorkspace() { return m_workspace; }
    Bool_t SetParInWS(const TString& parname, const Double_t& value);
    
    // not used, needed for baseclass
    Double_t GetValue() const;
    Double_t GetGaussRnd( Double_t mean ) const;
    Double_t GetRndValue( Double_t mean );
    Bool_t   SetValue( Double_t v );
    Double_t GetErrGaussp()   const;
    Double_t GetErrGaussm()   const;
    Double_t GetErrTotp()     const;
    Double_t GetErrTotm()     const;
    Double_t GetErrTotSym()   const;
    
   private:
      
    // MG
    // a parameter is exceptoinally allowed to change private members
    friend class GParameter;
    
    RooWorkspace* GetWorkspaceFromFile( const TString& infile, const TString& wsname );
    Bool_t SetModelConfig();
    Bool_t ConstructPLL();

    TString m_modelconfigstr;

    RooWorkspace* m_workspace; 
    RooStats::ModelConfig* m_modelconfig;
    RooAbsReal* m_nll;
    RooAbsReal* m_pll;

    ClassDef(GWorkspace,1)         
      
  };    
}

#endif
