/**********************************************************************************
 * Package: G2HDM                                                                 *
 * Class  : BR_BDTauNu                                                            *
 *                                                                                *
 * Description:                                                                   *
 *      B->Dtaunu branching fraction for 2HDM model                               *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef G2HDM_BR_BDTauNu
#define G2HDM_BR_BDTauNu

#include "G2HDM/G2HDMBase.h"



namespace G2HDM {
   
   class BR_BDTauNu : public G2HDMBase {
      
   public:

      BR_BDTauNu();
      virtual ~BR_BDTauNu() {}

      // theory prediction as function of parameters stored in GStore
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {}
      
   protected:

      // SM parameters
      Gfitter::GParameterRef m_mb_MSb;
      Gfitter::GParameterRef m_eps0;

      // model parameters
      Gfitter::GParameterRef m_f1;
      Gfitter::GParameterRef m_f2;
      Gfitter::GParameterRef m_f3;

      Gfitter::GParameterRef m_BR_BDenuSc;
      
   private:
      
      ClassDef(BR_BDTauNu,0)
  };
}

#endif
