/**********************************************************************************
 * Package: G2HDM                                                                 *
 * Class  : BR_BDeNu                                                              *
 *                                                                                *
 * Description:                                                                   *
 *      K->munu branching fraction for 2HDM model                                 *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef G2HDM_BR_BDeNu
#define G2HDM_BR_BDeNu

#include "Gfitter/GTheory.h"


   
namespace G2HDM {
   
   class BR_BDeNu : public Gfitter::GTheory {
      
   public:

      BR_BDeNu();
      virtual ~BR_BDeNu() {}

      // theory prediction as function of parameters stored in GStore
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {}
      
   protected:

      // SM parameters
      Gfitter::GParameterRef m_BR_BDenuSc;
      
   private:
      
      ClassDef(BR_BDeNu,0)
  };
}

#endif
