/**********************************************************************************
 * Package: G2HDM                                                                 *
 * Class  : BR_BLepNu                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * Source:   Wei-Shu Hou, PRD 48, 2342 (1993)                                     *
 *                                                                                *
 * see corresponding .h file for author and license information                   *               
 *                                                                                *
 **********************************************************************************/

#include <cmath>
#include <iostream>
#include "Riostream.h"

#include "TMath.h"
#include "Gfitter/GParameterRef.h"
#include "Gfitter/GMath.h"
#include "Gfitter/GConstants.h"
#include "Gfitter/GStore.h"
#include "Gfitter/GVariable.h"

#include "G2HDM/BR_BLepNu.h"

ClassImp(G2HDM::BR_BLepNu)

G2HDM::BR_BLepNu::BR_BLepNu() 
   : G2HDM::G2HDMBase(),
     m_mLepton( 0 ),
     m_useFullSMInput( kFALSE )
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
   
   // do we take the full theory, eg, from the global CKM fit ?
   if (Gfitter::gStore()->ExistVariable( "G2HDMFlags::UseFullSMInput" )) 
      m_useFullSMInput = Gfitter::gStore()->GetVariable( "G2HDMFlags::UseFullSMInput" )->GetBoolValue();

   // if the full SM prediction is used (from global CKM fit) we do not need these guys:
   if (!UseFullSMInput()) {
      BookParameter( "tauBu",   &m_tauBu );
      BookParameter( "|Vub|",   &m_Vub );
      BookParameter( "fBu",     &m_fBu );   
   }
}

Double_t G2HDM::BR_BLepNu::GetTheoryPrediction() 
{ 
   // Reference: Wei-Shu Hou, PRD 48, 2342 (1993)
   // Eqs. (10) and (11)
   // Note: expects the Bd lifetime given in ps

   Double_t tanBeta     = GetTanb();
   Double_t mChargedH   = GetMHch();

   // SM part
   Double_t brSM = 0;
   if (UseFullSMInput()) {
      brSM = m_BlepNuSM;
   }
   else {
      brSM = ( std::pow( Gfitter::GConstants::GF(), 2 ) * Gfitter::GConstants::mBu() * std::pow( m_mLepton, 2 ) 
               / 8.0 / TMath::Pi() 
               * std::pow( 1.0 - std::pow( m_mLepton/Gfitter::GConstants::mBu(), 2 ), 2 )
               * std::pow( m_fBu * m_Vub, 2 ) * m_tauBu / Gfitter::GConstants::hbar() );
   }

   // 2HDM part
   Double_t fac2HDM = std::pow( 1.0 - std::pow( tanBeta * Gfitter::GConstants::mBu() / mChargedH, 2 ), 2 );

   // combine
   return brSM * fac2HDM;
}
