/**********************************************************************************
 * Project: G2HDM - 2 Higgs Doublet Model (type -II) fitting package              *
 * Package: G2HDM                                                                 *
 * Class  : BR_KMuNu                                                              *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * Source: FlaviaNet Working Group on Kaon Decays                                 *
 *         Nucl.Phys.Proc.Suppl.181-182:83-88,2008, arXiv:0801.1817               *
 *                                                                                *
 * see corresponding .h file for author and license information                   *
 *                                                                                *
 **********************************************************************************/

#include <cmath>
#include <iostream>

#include "TMath.h"

#include "Gfitter/GParameterRef.h"
#include "Gfitter/GMath.h"
#include "Gfitter/GConstants.h"

#include "G2HDM/BR_KMuNu.h"

ClassImp(G2HDM::BR_KMuNu)

G2HDM::BR_KMuNu::BR_KMuNu() 
   : G2HDM::G2HDMBase()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
   
   BookParameter( "msmdRatio",  &m_msmdRatio );
   BookParameter( "epsilon0",   &m_eps0 );   
}

Double_t G2HDM::BR_KMuNu::GetTheoryPrediction() 
{ 
   // Reference: FlaviaNet Kaon Working Group arXiv:0801.1817
   // Eq. 4.17
   Double_t tanBeta     = GetTanb();
   Double_t mChargedH   = GetMHch();

   Double_t m_mKch        = Gfitter::GConstants::mKch();
   Double_t massRatio     = m_mKch*m_mKch/(mChargedH*mChargedH);
   Double_t tanBetaTerm   = tanBeta*tanBeta/(1+m_eps0*tanBeta);
   Double_t quarkMassTerm = 1-1/m_msmdRatio;

   Double_t Rl23 = TMath::Abs(1- massRatio*quarkMassTerm*tanBetaTerm);

   return Rl23;
}
