/**********************************************************************************
 * Package: G2HDM                                                                 *
 * Class  : BR_KMuNu                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      K->munu branching fraction for 2HDM model                                *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef G2HDM_BR_KMuNu
#define G2HDM_BR_KMuNu

#include "G2HDM/G2HDMBase.h"


   
namespace G2HDM {
   
   class BR_KMuNu : public G2HDMBase {
      
   public:

      BR_KMuNu();
      virtual ~BR_KMuNu() {}

      // theory prediction as function of parameters stored in GStore
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {}
      
   protected:

      // SM parameters
      Gfitter::GParameterRef m_msmdRatio;
      Gfitter::GParameterRef m_eps0;

      // 2HDM parameters

   private:
      
      ClassDef(BR_KMuNu,0)
  };
}

#endif
