/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : A0bFB                                                                 *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of forward-backward asymmetry of b-quarks                      *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_A0bFB
#define GEW_A0bFB
 
#include "GEW/SMTheoryBuilder.h"

namespace GEW {

   class A0bFB : public SMTheoryBuilder {
    
   public:

      A0bFB();
      virtual ~A0bFB() {}

      // theory prediction as function of parameters stored in GStore
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {}
 
   protected:

      ClassDef(A0bFB,0)
   };
}

#endif
