/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : Alep                                                                  *
 *                                                                                *
 * Description:                                                                   *
 *      Asymmetry paramter of leptons                                             *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_Alep
#define GEW_Alep

#include "SMTheoryBuilder.h"

namespace GEW {

   class GParameterRef;

   class Alep : public SMTheoryBuilder {
    
   public:

      Alep();
      virtual ~Alep() {}

      // theory prediction as function of parameters stored in GStore
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {}
 
   protected:
      
      ClassDef(Alep,0)
   };
}

#endif
