/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : GammaWtot                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of the total width of W                                        *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
 **********************************************************************************/
#include "TMath.h"

#include "Gfitter/GMath.h"
#include "Gfitter/GParameterRef.h"
#include "Gfitter/GTheoryRef.h"
#include "Gfitter/GTypes.h"

#include "GEW/GammaWtot.h"
#include "GEW/MW.h"

ClassImp(GEW::GammaWtot)

GEW::GammaWtot::GammaWtot()
   : SMTheoryBuilder()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
}

Double_t GEW::GammaWtot::GetTheoryPrediction()
{
   return GetWTheory().GetGammaW();
}



