/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : GammaZlept                                                            *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction for partial width of Z0->ll (usually not used in fit)          *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_GammaZlept
#define GEW_GammaZlept

#include "Gfitter/GParameterRef.h"
#include "Gfitter/GTheory.h"





namespace GEW {

   class MH;
   class DAlphaQED;

   class GammaZlept : public Gfitter::GTheory {

   public:
      
      GammaZlept();
      ~GammaZlept() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // init coefficients
      void Initialise();

   protected:
    
      // parameters from Data-Card
      Gfitter::GParameterRef p_mt;
      Gfitter::GParameterRef p_DAlphaHad;

      // reference to AlphasMZ
      Gfitter::GTheory& GetAlphasMZ() const { return (Gfitter::GTheory&)*t_AlphasMZ; }      
      Gfitter::GTheoryRef    t_AlphasMZ; 
 
      // reference to Higgs mass
      GEW::MH& GetMH() const{ return (GEW::MH&)*t_MH; }
      Gfitter::GTheoryRef t_MH;

      // coefficients for equation
      Double_t m_gZ0;
      Double_t m_g1;
      Double_t m_g2;
      Double_t m_g3;
      Double_t m_g4;
      Double_t m_g5;
      
      // OMS type
      // OMS1_2 = intermediate step
      enum OMSType { OMS1 = 1, OMS1_2, OMS2 };
      OMSType GetOMSType() const { return m_OMSType; }
      OMSType m_OMSType;
   
      Bool_t m_logMH;

      ClassDef(GammaZlept,0)
   };
}

#endif
