/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : GammaZtot                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of the total Z width                                           *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
 **********************************************************************************/
#include "GEW/GammaZtot.h"
#include "GEW/Z0Base.h"

ClassImp(GEW::GammaZtot)

GEW::GammaZtot::GammaZtot() : SMTheoryBuilder()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );

   BookParameter( "DeltaAlphasTheoC05_Scale",  &p_DeltaAlphasTheoC05_Scale );
   BookParameter( "DeltaAlphasTheoCMt4_Scale", &p_DeltaAlphasTheoCMt4_Scale );
   BookTheory   ( "GEW::AlphaQCDAtQ/MZ",  &t_AlphasMZ );   

}

Double_t GEW::GammaZtot::GetTheoryPrediction()
{   
   Double_t gaztot = 0;

   Double_t GaZnu  = GetZ0Theory().GetGaZneutrino(); 
   Double_t GaZe   = GetZ0Theory().GetGaZelectron();  
   Double_t GaZmu  = GetZ0Theory().GetGaZmuon(); 
   Double_t GaZtau = GetZ0Theory().GetGaZtau();
   Double_t GaZhad = GetZ0Theory().GetGaZhad();  
   
   gaztot = 3.0*GaZnu + GaZe + GaZmu + GaZtau + GaZhad;

   // theory uncertainty due to missing h.o. terms in radiator function
   // uncertainty due to C05 term in radiator function
   Double_t asmz = GetAlphasMZ();
   Double_t unc_c05 = 1.37985*GMath::IPow(asmz,4);
   gaztot += unc_c05*(1 - p_DeltaAlphasTheoC05_Scale);

   // uncertainty due to CMt4 term in radiator function
   Double_t unc_mt4 =  -0.224095*GMath::IPow(asmz,4);
   gaztot += unc_mt4*(1 - p_DeltaAlphasTheoCMt4_Scale);
 
   return gaztot;

}
