/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : GammaWtot                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of the total Z width                                           *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_GammaZtot
#define GEW_GammaZtot
 
#include "GEW/SMTheoryBuilder.h"

namespace GEW {

   class GammaZtot : public SMTheoryBuilder {
    
   public:

      GammaZtot();
      virtual ~GammaZtot() {}

      // theory prediction as function of parameters stored in GStore
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {}
 
   protected:

      Gfitter::GParameterRef p_DeltaAlphasTheoC05_Scale;  // for C05 coefficient of Radiator function
      Gfitter::GParameterRef p_DeltaAlphasTheoCMt4_Scale; // for CMt4 coefficient of Radiator function

      // reference to AlphasMZ
      Gfitter::GTheory& GetAlphasMZ() const { return (Gfitter::GTheory&)*t_AlphasMZ; } 
      Gfitter::GTheoryRef t_AlphasMZ;       
      
      Bool_t m_fullTwoLoop;

      ClassDef(GammaZtot,0)
   };
}

#endif
