/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : HiggsTheoryBound                                                      *
 *                                                                                *
 * Description:                                                                   *
 *      This base class implements strict (!) bounds on the Higgs boson mass,     *
 *      where strict means MH >(<) MH_critical gets a infinite contribution       *
 *      to the chi-squared                                                        *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
**********************************************************************************/

#ifndef GEW_HiggsTheoryBound
#define GEW_HiggsTheoryBound

#include "Gfitter/GTheory.h"

class TGraph;



namespace GEW {

   class MH;

   class HiggsTheoryBound : public Gfitter::GTheory {

   public:
      
      HiggsTheoryBound();
      ~HiggsTheoryBound() {}      

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      virtual void Initialise();
      
   protected:

      enum BoundType { kNone = 0, kLower, kUpper };

      // provide critical mass and determine whether lower or upper bound
      BoundType m_boundType;      
      virtual Double_t GetCriticalMass() = 0;      

      // reference to Higgs mass
      GEW::MH& GetMH() const{ return (GEW::MH&)*t_MH; }
      Gfitter::GTheoryRef t_MH;

      // parameters from the Data-Card
      Gfitter::GParameterRef p_Log10LambdaCutoff;

      // read theories from files
      const TGraph* GetGraphFromFile( const TString& fname ) const;

   private:

      void CalculateVariables();

      Int_t m_sign; // this is the sign corresponding to the bound

      ClassDef(HiggsTheoryBound,0)
   };
}

#endif
