/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : HiggsThermMetastabilityBound                                          *
 *                                                                                *
 * Description:                                                                   *
 *      Bound obtained from vacuum stability requirement:                         *
 *      lambda(mu) > 0 for mu < Lambda_cutoff                                     *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
**********************************************************************************/

#ifndef GEW_HiggsThermMetastabilityBound
#define GEW_HiggsThermMetastabilityBound

#include "GEW/HiggsTheoryBound.h"

class TGraph;

namespace GEW {

   class HiggsThermMetastabilityBound : public GEW::HiggsTheoryBound {

   public:
      
      HiggsThermMetastabilityBound();
      ~HiggsThermMetastabilityBound() {}      

      // Initialise coefficients
      void Initialise();
      
   protected:

      Double_t GetCriticalMass();

      Gfitter::GParameterRef p_mt;

      Gfitter::GTheory&      GetAlphasMZ() const { return (Gfitter::GTheory&)*t_AlphasMZ; }      
      Gfitter::GTheoryRef    t_AlphasMZ; 

   private:

      ClassDef(HiggsThermMetastabilityBound,0)
   };
}

#endif
