/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : R0c                                                                   *
 *                                                                                *
 * Description:                                                                   *
 *      Ratio of the charms partial Z width to all hadrons                        *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
 **********************************************************************************/
#include "GEW/R0c.h"
#include "GEW/Z0Base.h"

ClassImp(GEW::R0c)

GEW::R0c::R0c() : SMTheoryBuilder()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );

   BookParameter( "DeltaAlphasTheoC05_Scale",  &p_DeltaAlphasTheoC05_Scale );
   BookParameter( "DeltaAlphasTheoCMt4_Scale", &p_DeltaAlphasTheoCMt4_Scale );
   BookTheory   ( "GEW::AlphaQCDAtQ/MZ",  &t_AlphasMZ );   

}

Double_t GEW::R0c::GetTheoryPrediction()
{   
   Double_t GaZhad = GetZ0Theory().GetGaZhad();
   Double_t GaZc   = GetZ0Theory().GetGaZcharm();
          
   Double_t r0c = GaZc/GaZhad;

   // theory uncertainty due to missing h.o. terms in radiator function
   // uncertainty due to C05 term in radiator function
   Double_t asmz = GetAlphasMZ();
   Double_t unc_c05 = -0.0409506*TMath::Power(asmz,5.7);
   r0c += unc_c05*(1 - p_DeltaAlphasTheoC05_Scale);

   // uncertainty due to CMt4 term in radiator function
   Double_t unc_mt4 =  0.1529*GMath::IPow(asmz,4);
   r0c += unc_mt4*(1 - p_DeltaAlphasTheoCMt4_Scale);
   
   return r0c;
}
