/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : R0lep                                                                 *
 *                                                                                *
 * Description:                                                                   *
 *      Ratio of allhadrons Z width to the leptons one                            *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_R0lep
#define GEW_R0lep
 
#include "GEW/SMTheoryBuilder.h"

namespace GEW {

   class R0lep : public SMTheoryBuilder {
    
   public:

      R0lep();
      virtual ~R0lep() {}

      // theory prediction as function of parameters stored in GStore
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {}

  protected:
      Gfitter::GParameterRef p_DeltaAlphasTheoC05_Scale;  // for C05 coefficient of Radiator function
      Gfitter::GParameterRef p_DeltaAlphasTheoCMt4_Scale; // for CMt4 coefficient of Radiator function

      // reference to AlphasMZ
      Gfitter::GTheory& GetAlphasMZ() const { return (Gfitter::GTheory&)*t_AlphasMZ; } 
      Gfitter::GTheoryRef t_AlphasMZ;       

      ClassDef(R0lep,0)
   };
}

#endif
