/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : RadiatorFunctions                                                     *
 *                                                                                *
 * Description:                                                                   *
 *      Auxiliary Theory                                                          *
 *        QCD Radiator Functions                                                  *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_RadiatorFunctions
#define GEW_RadiatorFunctions

#include "Gfitter/GAuxTheory.h"
#include "Gfitter/GTypes.h"
  




namespace GEW {

   class QMassRunning;
   class DAlphaQED;

   class RadiatorFunctions : public Gfitter::GAuxTheory {

   public:
      
      RadiatorFunctions();
      ~RadiatorFunctions() {}

      // initalize coefficients
      virtual void Initialise();

      // dummy prediction
      Double_t GetTheoryPrediction() { return 0; }

      // vector and axial radiator functions 
      Double_t GetRVq( Gfitter::GTypes::Particle particle, Double_t Charge );
      Double_t GetRAq( Gfitter::GTypes::Particle particle, Double_t Charge, Double_t T3 );
      Double_t GetrVS(){ Update(); return m_rVS; };

   protected:

      // update of flags in case of parameter change
      void UpdateLocalFlags( Gfitter::GReference& ref );

      // update paramters
      void Update();

      // auxiliary parameters
      Double_t m_asMZpi;
      Double_t m_aQEDMZpi;
      
      Double_t m_mc;  
      Double_t m_mb;  
      Double_t m_RatioMcMZ; 
      Double_t m_RatioMbMZ;  
      Double_t m_RatioMZMt;  
      
      Double_t m_UnivQuadratic;   
      Double_t m_UnivQuartic;

      // parameters from the Data-Card
      Gfitter::GParameterRef p_MZ;
      Gfitter::GParameterRef p_mt;

      // reference to DAlphaQED
      DAlphaQED& GetDAlphaQED() const { return (DAlphaQED&)*t_DAlphaQED; }      
      Gfitter::GTheoryRef    t_DAlphaQED; 
      
      // reference to QMassRunning
      QMassRunning& GetQMassRun() const { return (QMassRunning&)*t_qMassRun; }      
      Gfitter::GTheoryRef    t_qMassRun;
   
      // reference to AlphasMZ
      Gfitter::GTheory& GetAlphasMZ() const { return (Gfitter::GTheory&)*t_AlphasMZ; }      
      Gfitter::GTheoryRef    t_AlphasMZ; 

      // scale parameter to estimate theoretical uncertainties: set to one for NO efffect
      Gfitter::GParameterRef p_DeltaAlphasTheoC05_Scale;  // for C05 coefficient
      Gfitter::GParameterRef p_DeltaAlphasTheoCMt4_Scale; // for CMt4 coefficient
      Gfitter::GParameterRef p_DeltaAlphasTheoMassive_Scale;   // massive contribution

    
      // flag to compute radiator function to alpha_s NLO only
      Bool_t   m_useNLOAlphasOnly;

      // coefficients (see source file for definitions)
      Double_t m_C02;
      Double_t m_C03;
      Double_t m_C04;
      Double_t m_C05;
      
      Double_t m_C23;

      Double_t m_CV21;
      Double_t m_CV22;
      Double_t m_CV23;
      
      Double_t m_CV40;
      Double_t m_CV41;
      Double_t m_CV42;
      
      Double_t m_CVL42;

      Double_t m_CA20;
      Double_t m_CA21;
      Double_t m_CA22;
      Double_t m_CA23;

      Double_t m_CA40;
      Double_t m_CA41;
      Double_t m_CA42;

      Double_t m_CAL42;

      Double_t m_C42;
      Double_t m_Ct2;
      
      Double_t m_I_2;
      Double_t m_I_3;
      Double_t m_I_4;
      Double_t m_I_5;

      Double_t m_rVS;
      
   private:

      // boolean flags to track recomputation
      Bool_t m_isUpToDate_Update;
      
      ClassDef(RadiatorFunctions,0)
   };
}

#endif
