/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : SMTheoryBuilder                                                       *
 *                                                                                *
 * Description:                                                                   *
 *      SM theory builder                                                         *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
 **********************************************************************************/
#include "TString.h"

#include "Gfitter/GVariable.h"
#include "Gfitter/GStore.h"
#include "Gfitter/GTheoryRef.h"

#include "GEW/SMTheoryBuilder.h"

using namespace Gfitter;

ClassImp(GEW::SMTheoryBuilder)

GEW::SMTheoryBuilder::SMTheoryBuilder()
   : Gfitter::GTheory()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );

   const TString& theory = gStore()->GetVariable( "GEWFlags::Theory" )->GetStringValue();
   m_logger << kINFO << "Using Theory type: \"" << theory << "\"" << GEndl;
   
   if( theory == "Parametrisation"){
      BookTheory( "GEW::Z0Parametrisation", &m_z0Theory );
      BookTheory( "GEW::WParametrisation",  &m_wTheory );
   }
   else {
      m_logger << kFATAL << "unknown value for \"GEWFlags::Theory\": \"" << theory << "\""
               << ". Possible are: \"Parametrisation\"" << GEndl;
   }
}
