/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : SMTheoryBuilder                                                       *
 *                                                                                *
 * Description:                                                                   *
 *      SM theory builder                                                         *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_SMTheoryBuilder
#define GEW_SMTheoryBuilder

#include "Gfitter/GTheory.h"

#include "GEW/Z0Parametrisation.h"
#include "GEW/WParametrisation.h"



namespace GEW {

   class Z0Base;
   class WBase;

   class SMTheoryBuilder : public Gfitter::GTheory {

   public:
      
      SMTheoryBuilder();
      ~SMTheoryBuilder() {}

   protected:

      Z0Base& GetZ0Theory() { return (Z0Base&)*m_z0Theory; }
      Gfitter::GTheoryRef m_z0Theory;

      WBase& GetWTheory() { return (WBase&)*m_wTheory; }
      Gfitter::GTheoryRef m_wTheory;


      ClassDef(SMTheoryBuilder,0)
   };
}

#endif
