/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : SinEffLep                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of effective leptonic weak mixing angle                        *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
 **********************************************************************************/
#include "GEW/SinEffLep.h"
#include "GEW/Z0Base.h"

#include "Gfitter/GTypes.h"

ClassImp(GEW::SinEffLep)

GEW::SinEffLep::SinEffLep()
   : SMTheoryBuilder()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
}

Double_t GEW::SinEffLep::GetTheoryPrediction()
{
   return GetZ0Theory().GetSin2Eff(Gfitter::GTypes::kElectron);
}
