/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : SinEffLep                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of effective leptonic weak mixing angle                        *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_SinEffLep
#define GEW_SinEffLep

#include "GEW/SMTheoryBuilder.h"

using namespace Gfitter;




namespace GEW {

   class Sin2ThetaF;

   class SinEffLep : public SMTheoryBuilder {

   public:
      
      SinEffLep();
      ~SinEffLep() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {}

   protected:
      
      ClassDef(SinEffLep,0)
   };
}

#endif
