/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : WBase                                                                 *
 *                                                                                *
 * Description:                                                                   *
 *      W Base class for W width                                                  *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_WBase
#define GEW_WBase

#include "Gfitter/GAuxTheory.h"





namespace GEW {

   class WBase : public Gfitter::GAuxTheory {

   public:
      
      WBase();
      virtual ~WBase() {}
    
      // not used
      void Initialise() {};

      virtual Double_t GetGammaW() = 0;
      
   protected:
      
      // Data-Card members
      Gfitter::GParameterRef p_MZ; 
      Gfitter::GParameterRef p_GF; 
      
      Double_t m_gammaW;

   private:

      ClassDef(WBase,0)
   };
}

#endif
