/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : Z0Base                                                                *
 *                                                                                *
 * Description:                                                                   *
 *      Base class for EW fits (Z0 properties)                                    *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_Z0Base
#define GEW_Z0Base

#include "Gfitter/GAuxTheory.h"
#include "Gfitter/GTypes.h"
#include "Gfitter/GMath.h"
#include "GEW/Sin2ThetaF.h"
#include "GEW/DAlphaQED.h"
#include "GEW/MH.h"





namespace GEW {
  
   class Z0Base : public Gfitter::GAuxTheory {

   public:
      
      Z0Base();
      ~Z0Base() {}
      
      // accessors
      virtual Double_t GetSin2Eff( Gfitter::GTypes::Particle particle )  = 0;
      virtual Double_t GetGaZelectron() = 0;
      virtual Double_t GetGaZmuon()     = 0;
      virtual Double_t GetGaZtau()      = 0;
      virtual Double_t GetGaZneutrino() = 0;
      virtual Double_t GetGaZup()       = 0;
      virtual Double_t GetGaZdown()     = 0;
      virtual Double_t GetGaZstrange()  = 0;
      virtual Double_t GetGaZcharm()    = 0;
      virtual Double_t GetGaZbottom()   = 0;
      virtual Double_t GetGaZhad()      = 0;
      virtual Double_t GetDeltaS()      = 0;
      virtual Double_t GetDeltaT()      = 0;
      virtual Double_t GetgAeff( Gfitter::GTypes::Particle particle, Double_t T3, Double_t ch ) = 0;
      virtual Double_t GetgVeff( Gfitter::GTypes::Particle particle, Double_t T3, Double_t ch ) = 0;

      virtual Bool_t DoFullTwoLoop() = 0;
      virtual void   SetFullTwoLoop( const Bool_t& fullTwoLoop ) = 0;
      
   protected:

      // the dependents
      Gfitter::GParameterRef p_mt;
      Gfitter::GParameterRef p_MZ;
      Gfitter::GParameterRef p_GF;

      // reference to Sin2ThetaF
      Sin2ThetaF& GetSinEffF() const { return (Sin2ThetaF&)*t_sineff; }      
      Gfitter::GTheoryRef    t_sineff;

      // reference to Higgs mass
      GEW::MH& GetMH() const{ return (GEW::MH&)*t_MH; }
      Gfitter::GTheoryRef t_MH;

      // reference to DAlphaQED
      DAlphaQED& GetDAlphaQED() const { return (DAlphaQED&)*t_DAlphaQED; }      
      Gfitter::GTheoryRef    t_DAlphaQED; 
 
      // reference to AlphasMZ
      Gfitter::GTheory& GetAlphasMZ() const { return (Gfitter::GTheory&)*t_AlphasMZ; }      
      Gfitter::GTheoryRef    t_AlphasMZ; 
    
 
      ClassDef(Z0Base,0)
   };
  
}

#endif
