{

  gStyle->SetOptStat(0);
  TGraphErrors* g = new TGraphErrors();
  g->SetPoint(0, 0.1, 1e-5);
  g->SetPoint(1, 0.14, 4e-5);
  g->SetPointError(0, 0, 0.1e-6);
  g->SetPointError(1, 0, 0.1e-6);
  g->SetMarkerStyle(20);

  TH1F* h = new TH1F("h", "", 1, 0.096, 0.144);
  h->GetYaxis()->SetRangeUser(-5e-5, 5e-5);
  h->Draw();

  TF1* f = new TF1("f", "[0]+[1]*TMath::Power(x,4)", 0.1, 0.14);
  f->SetParameters(1e-5, 1e-1);
  f->SetParLimits(0, 0, 0.1);
  f->SetLineColor(kBlue);

  g->Fit(f);
  
  g->Draw("Psame");
  f->Draw("same");

  TF1* fd = new TF1("fd", "[0]+[1]*TMath::Power(x,4)", 0.1, 0.14);
  fd->SetParameters((-1)*f->GetParameter(0), (-1)*f->GetParameter(1));
  fd->SetLineColor(kRed);

  fd->Draw("same");

  cout << "p0 = " << f->GetParameter(0) << endl;
  cout << "p1 = " << f->GetParameter(1) << endl;


}
