/**********************************************************************************
 * Project: GOblique - Electroweak fitting package                                *
 * Package: GOblique                                                              *
 * Class  : Epsilon2                                                              *
 *                                                                                *
 * Description:                                                                   *
 *      epsilon2                                                                  *
 *                                                                                *  
 * Authors:                                                                       *  
 *      Gfitter group                                                             *  
 *                                                                                *  
 * Redistribution and use in source and binary forms, with or without             * 
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *            
 **********************************************************************************/

#ifndef GOblique_Epsilon2
#define GOblique_Epsilon2
 
#include "Gfitter/GTheory.h"



namespace GOblique {

   class EpsilonParametrisation;

   class Epsilon2 : public Gfitter::GTheory {
    
   public:

      Epsilon2();
      virtual ~Epsilon2() {}

      // theory prediction as function of parameters stored in GStore
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {}
 
   protected:

      // reference to EpsilonParametrisation
      EpsilonParametrisation& GetPara() const { return (EpsilonParametrisation&)*t_Para; }  
      Gfitter::GTheoryRef    t_Para;  
      
      ClassDef(Epsilon2,0)
   };
}

#endif


