/**********************************************************************************
 * Project: GOblique - Electroweak fitting package                                *
 * Package: GOblique                                                              *
 * Class  : Epsilon3                                                              *
 *                                                                                *
 * Description:                                                                   *
 *      epsilon3                                                                  *
 *                                                                                *
 * Authors:                                                                       * 
 *      Gfitter group                                                             * 
 *                                                                                * 
 * Redistribution and use in source and binary forms, with or without             * 
 * modification, are permitted according to the terms listed in the file          * 
 * LICENSE.                                                                       * 
 **********************************************************************************/

#ifndef GOblique_Epsilon3
#define GOblique_Epsilon3
 
#include "Gfitter/GTheory.h"



namespace GOblique {

   class EpsilonParametrisation;

   class Epsilon3 : public Gfitter::GTheory {
    
   public:

      Epsilon3();
      virtual ~Epsilon3() {}

      // theory prediction as function of parameters stored in GStore
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {}
 
   protected:

      // reference to EpsilonParametrisation
      EpsilonParametrisation& GetPara() const { return (EpsilonParametrisation&)*t_Para; }  
      Gfitter::GTheoryRef    t_Para;  
      
      ClassDef(Epsilon3,0)
   };
}

#endif


