/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : A0bFB                                                                 *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * Sources:                                                                       *
 *      - C. P. Burgess, Pramana 45 , S47 (1995), [arXiv:hep-ph/9411257]          *
 *        (see also references)                                                   *
 *      - C. P. Burgess, S. Godfrey, H. Konig, D. London and I. Maksymyk          *
 *        Phys. Rev.  D 49, 6115 (1994), [arXiv:hep-ph/9312291]                   *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/
#include "GSTU/A0bFB.h"

ClassImp(GSTU::A0bFB)

GSTU::A0bFB::A0bFB(): SMPredictions(){}

Double_t GSTU::A0bFB::GetTheoryPrediction()
{
   Update();
   // see table 1 from hep-ph/9411257
   // for Z->bb vertex corrections added from eq.(105) of hep-ph/9312291
   Double_t retVal = GetSM_A0bFB() - 0.0188*GetS() + 0.0131*GetT() - 0.0406*GetX() 
      - 0.0322*Get_deltagLb() - 0.178*Get_deltagRb();
   
   return retVal;
}
