/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : A0cFB                                                                 *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * Source:                                                                        *
 *      - C. P. Burgess, Pramana 45 , S47 (1995), [arXiv:hep-ph/9411257]          *
 *        (see also references)                                                   *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/
#include "GSTU/A0cFB.h"

ClassImp(GSTU::A0cFB)

GSTU::A0cFB::A0cFB(): SMPredictions(){}

Double_t GSTU::A0cFB::GetTheoryPrediction()
{
   Update();
   
   // see table 1 from hep-ph/9411257
   Double_t retVal = GetSM_A0cFB() - 0.0147*GetS() + 0.0104*GetT() - 0.03175*GetX();
   
   return retVal;
}
