/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : A0lepFB                                                               *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of FB asymmetry of charged leptons                             *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_A0lepFB
#define GSTU_A0lepFB

#include "GSTU/SMPredictions.h"

namespace GSTU {

   class A0lepFB : public SMPredictions {

   public:
      
      A0lepFB();
      ~A0lepFB() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise() {}

   protected:
      
      ClassDef(A0lepFB,0)
   };
}

#endif
