/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : Alep                                                                  *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of asymmetry parameter of charged leptons                      *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_Alep
#define GSTU_Alep

#include "GSTU/SMPredictions.h"

namespace GSTU {

   class Alep : public SMPredictions {

   public:
      
      Alep();
      ~Alep() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise() {}

   protected:
      
      ClassDef(Alep,0)
   };
}

#endif
