/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : GammaWtot                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of total width of W boson                                      *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_GammaWtot
#define GSTU_GammaWtot

#include "GSTU/SMPredictions.h"

namespace GSTU {

   class GammaWtot : public SMPredictions {

   public:
      
      GammaWtot();
      ~GammaWtot() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise() {}

   protected:
      
      ClassDef(GammaWtot,0)
   };
}

#endif
