/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : IDM_Constraint1                                                       *
 *                                                                                *
 * Description:                                                                   *
 *     2*ML+Delta_M > MZ                                                          *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_IDM_Constraint1
#define GSTU_IDM_Constraint1

#include "Gfitter/GTheory.h"




namespace GSTU {

   class IDM_Constraint1 : public Gfitter::GTheory {

   public:
      
      IDM_Constraint1();
      ~IDM_Constraint1() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise() {}

   protected:
      
      Gfitter::GParameterRef p_MZ; 
      Gfitter::GParameterRef p_ML; 
      Gfitter::GParameterRef p_DeltaM; 
      
      ClassDef(IDM_Constraint1,0)
   };
}

#endif


#ifndef GSTU_IDM_Constraint1ch
#define GSTU_IDM_Constraint1ch

#include "Gfitter/GTheory.h"




namespace GSTU {

   class IDM_Constraint1ch : public Gfitter::GTheory {

   public:
      
      IDM_Constraint1ch();
      ~IDM_Constraint1ch() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise() {}

   protected:
      
      Gfitter::GParameterRef p_MZ; 
      Gfitter::GParameterRef p_ML; 
      Gfitter::GParameterRef p_MA0; 
      
      ClassDef(IDM_Constraint1ch,0)
   };
}

#endif
