/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : IDM_Constraint2                                                       *
 *                                                                                *
 * Description:                                                                   *
 *     - ML < MHcharge                                                            *
 *     - lightest neutral Higgs lighter than charged states => dark matter        *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/

#include "GSTU/IDM_Constraint2.h"

#include "Gfitter/GTheory.h"
#include "Gfitter/GTheoryRef.h"
#include "Gfitter/GParameterRef.h"
#include "Gfitter/GReference.h"

#include "TMath.h"

using namespace Gfitter;

ClassImp(GSTU::IDM_Constraint2)


GSTU::IDM_Constraint2::IDM_Constraint2(): Gfitter::GTheory()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );

   BookParameter( "MHcharge", &p_MHcharge );
   BookParameter( "ML",       &p_ML );
}

Double_t GSTU::IDM_Constraint2::GetTheoryPrediction()
{
   return p_MHcharge - p_ML;
}
