/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : IDM_Constraint2                                                       *
 *                                                                                *
 * Description:                                                                   *
 *     ML < MHcharge                                                              *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_IDM_Constraint2
#define GSTU_IDM_Constraint2

#include "Gfitter/GTheory.h"




namespace GSTU {

   class IDM_Constraint2 : public Gfitter::GTheory {

   public:
      
      IDM_Constraint2();
      ~IDM_Constraint2() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise() {}

   protected:
      
      Gfitter::GParameterRef p_ML; 
      Gfitter::GParameterRef p_MHcharge; 
      
      ClassDef(IDM_Constraint2,0)
   };
}

#endif

#ifndef GSTU_IDM_Constraint2ch
#define GSTU_IDM_Constraint2ch

#include "Gfitter/GTheory.h"




namespace GSTU {

   class IDM_Constraint2ch : public Gfitter::GTheory {

   public:
      
      IDM_Constraint2ch();
      ~IDM_Constraint2ch() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise() {}

   protected:
      
      Gfitter::GParameterRef p_DeltaMch; 
      
      ClassDef(IDM_Constraint2ch,0)
   };
}

#endif
