/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : LED_amu                                                               *
 *                                                                                *
 * Description:                                                                   *
 *      Estimate of the anamalous magnetic moment of the muon                     *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_LED_amu
#define GSTU_LED_amu

#include "Gfitter/GTheory.h"
#include "Gfitter/GTheoryRef.h"
#include "Gfitter/GParameterRef.h"

namespace GSTU {

   class LED_amu : public Gfitter::GTheory {

   public:
      
      LED_amu();
      ~LED_amu() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise() {}

   protected:
      
      Int_t m_ndim;
      bool m_logScale;
      
      Gfitter::GParameterRef p_MD; 
      Gfitter::GParameterRef p_logMD; 

      Gfitter::GParameterRef p_LambdaMD; 
      Gfitter::GParameterRef p_logLambdaMD; 

      ClassDef(LED_amu,0)
   };
}

#endif
