/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : LHmtplus                                                              *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * Source:                                                                        *
 *      - J. Hubisz, P. Meade, A. Noble and M. Perelstein,                        *
 *        JHEP 0601, 135 (2006), [arXiv:hep-ph/0506042]                           *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/

#include "Gfitter/GTheory.h"
#include "Gfitter/GParameterRef.h"
#include "Gfitter/GConstants.h"

#include "GSTU/LHmtplus.h"

using namespace Gfitter;

ClassImp(GSTU::LHmtplus)

GSTU::LHmtplus::LHmtplus()
   : Gfitter::GTheory()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
  
   BookParameter( "mt",      &p_mt );   
   BookParameter( "slambda", &p_slambda );   
   BookParameter( "f",       &p_f );   
}

// mtplus as parametrization of R = lambda1/lambda2
// re-parametrization of eq. (2.26) from hep-ph/0506042
Double_t GSTU::LHmtplus::GetTheoryPrediction()
{
   Double_t R = TMath::Sqrt(1./(p_slambda*p_slambda) - 1);

   Double_t retval = p_mt*(1.+R*R) / (R*GConstants::vev())*p_f;
   
   return retval;
}
