/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : LHmtplus                                                              *
 *                                                                                *
 * Description:                                                                   *
 *      Mass of T-even top partner                                                *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_LHmtplus
#define GSTU_LHmtplus

#include "Gfitter/GTheory.h"




namespace GSTU {

   class DAlphaQED;

   class LHmtplus : public Gfitter::GTheory {

   public:
      
      LHmtplus();
      ~LHmtplus() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise() {};

   protected:
    
      // parameters from the Data-Card
      Gfitter::GParameterRef p_slambda;
      Gfitter::GParameterRef p_mt;
      Gfitter::GParameterRef p_f;
      
      ClassDef(LHmtplus,0)
   };
}

#endif
