/**********************************************************************************
 * Project: GSTU - GSTU Parameter fitting package                                 *
 * Package: GSTU                                                                  *
 * Class  : MAgmh                                                                 *
 *                                                                                *
 * Description:                                                                   *
 *      SUSY helper class                                                         *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/

#include "GSTU/MAgmh.h"
#include "Gfitter/GReference.h"
#include "Gfitter/GParameterRef.h"
#include "Gfitter/GTheoryRef.h"
#include "Gfitter/GMsgLogger.h"


ClassImp(GSTU::MAgmh)

using namespace Gfitter;

GSTU::MAgmh::MAgmh()
 : Gfitter::GTheory()
 , m_isUpToDate_Update(kFALSE)
 , m_value(-999.)
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
  
   Initialise();

   /// Book your parameters and theories here below
  
   BookParameter ( "MA", &p_MA );
   BookParameter ( "MH", &p_MH );
}


void GSTU::MAgmh::Initialise() 
{
   /// Initialization goes here
}


void GSTU::MAgmh::UpdateLocalFlags( Gfitter::GReference& /*ref*/ )
{
   m_isUpToDate_Update = kFALSE;
}


void GSTU::MAgmh::Update()
{
   if(m_isUpToDate_Update) return;  
   m_isUpToDate_Update = kTRUE;
   
   /// your parameter updates here
   m_value = p_MA-p_MH ;
   
   SetUpToDate(); 
}


Double_t GSTU::MAgmh::GetTheoryPrediction()
{
   /// your theory prediction goes here
   Update();

   return m_value;
}

