/**********************************************************************************
 * Project: GSTU - GSTU Parameter fitting package                                 *
 * Package: GSTU                                                                  *
 * Class  : MH0gmh                                                                *
 *                                                                                *
 * Description:                                                                   *
 *      SUSY helper class                                                         *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/

#include "GSTU/MH0gmh.h"
#include "Gfitter/GReference.h"
#include "Gfitter/GParameterRef.h"
#include "Gfitter/GTheoryRef.h"
#include "Gfitter/GMsgLogger.h"


ClassImp(GSTU::MH0gmh)

using namespace Gfitter;

GSTU::MH0gmh::MH0gmh()
 : Gfitter::GTheory()
 , m_isUpToDate_Update(kFALSE)
 , m_value(-999.)
{
  SetTheoryName( GetName() );
  SetExistDerivative( kFALSE );
  
  Initialise();

  /// Book your parameters and theories here below
  
  BookParameter ( "MH0", &p_MH0 );
  BookParameter ( "MH", &p_MH );
}


void GSTU::MH0gmh::Initialise() 
{
   /// Initialization goes here
}


void GSTU::MH0gmh::UpdateLocalFlags( Gfitter::GReference& /*ref*/ )
{
   m_isUpToDate_Update = kFALSE;
}


void GSTU::MH0gmh::Update()
{
   if(m_isUpToDate_Update) return;  
   m_isUpToDate_Update = kTRUE;
  
   m_value = p_MH0-p_MH;

   /// your parameter updates here
   SetUpToDate(); 
}


Double_t GSTU::MH0gmh::GetTheoryPrediction()
{
   /// your theory prediction goes here
   Update();

   return m_value;
}

