/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : TwoHDM                                                                *
 *                                                                                *
 * Description:                                                                   *
 *      STU electroweak corrections from the Two Higgs Doublet model              *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_TwoHDM
#define GSTU_TwoHDM

#include "GSTU/TheoryBase.h"

#include "GEW/MW.h"






namespace GSTU {

   class TwoHDM : public TheoryBase {

   public:
      
      TwoHDM();
      virtual ~TwoHDM() {}

      Double_t GetS();
      Double_t GetT();
      Double_t GetU();
      // are set to zero in this model
      Double_t GetV(){ return 0; };
      Double_t GetW(){ return 0; };
      Double_t GetX(){ return 0; };

      // additional corrections to Z->bb couplings 
      Double_t Get_deltagLb(){ return 0; };
      Double_t Get_deltagRb(){ return 0; };

		// Intermediate functions to calculate S,T,and U
		Double_t B22( Double_t, Double_t, Double_t);
		Double_t B0( Double_t, Double_t, Double_t);
		Double_t Bbar0( Double_t, Double_t, Double_t);
		Double_t G( Double_t);
		Double_t F( Double_t, Double_t);
		Double_t f( Double_t, Double_t);
		Double_t Delta( Double_t, Double_t);

      // Initialise coefficients
      void Initialise();

   protected:
      
      // parameters

      Gfitter::GParameterRef p_MZ;
      Gfitter::GParameterRef p_mt;

		//2HDM parameters
		Gfitter::GParameterRef p_MH;
		Gfitter::GParameterRef p_MH0;
		Gfitter::GParameterRef p_MA;
		Gfitter::GParameterRef p_MHcharge;
		Gfitter::GParameterRef p_betaminusalpha;

      // reference to MW
      GEW::MW& GetMW() const { return (GEW::MW&)*t_MW; }      
      Gfitter::GTheoryRef t_MW; 

      ClassDef(TwoHDM,0)
   };
}

#endif
