/**********************************************************************************
 * Project: Gfitter - a Root-integrated toolkit for multivariate data analysis    *
 * Package: Gfitter                                                               *
 * Class  : SigmaVis                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Dummy theory                                                              *
 *                                                                                *
 **********************************************************************************/

#ifndef Gfitter_SigmaVis
#define Gfitter_SigmaVis

#include "Gfitter/GTheory.h"

namespace GTest {

   

   class SigmaVis : public Gfitter::GTheory {
    
   public:

      SigmaVis();
      virtual ~SigmaVis() {}

      // theory prediction as function of parameters stored in GStore
      virtual Double_t GetTheoryPrediction();

      // not used
      void Initialise() {};
      
   protected:

      Double_t m_mainparam;
      Gfitter::GParameterRef m_sigmaVis;
      Gfitter::GParameterRef m_sigmaVis_errSystCorr;
      Gfitter::GParameterRef m_sigmaVis_errBeamcurCorr;
      Gfitter::GParameterRef m_sigmaVis_errBeamcurUncorr;

      ClassDef(SigmaVis,0)
  };
}

#endif
