/**********************************************************************************
 * Project: Gfitter - a Root-integrated toolkit for multivariate data analysis    *
 * Package: Gfitter                                                               *
 * Class  : GTheory                                                               *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 **********************************************************************************/

#include <iostream>
#include "Riostream.h"
#include "Gfitter/GParameterRef.h"
#include "GTest/SigmaVis_PVtight.h"

ClassImp(GTest::SigmaVis_PVtight)

GTest::SigmaVis_PVtight::SigmaVis_PVtight() 
: GTest::SigmaVis()
{
   SetTheoryName( GetClassName() );
   SetExistDerivative( kFALSE );
   
   BookParameter("sigmaVis_PVtight", &m_sigmaVis);
   BookParameter("sigmaVis_errSystCorr_PVtight", &m_sigmaVis_errSystCorr);
   BookParameter("sigmaVis_errBeamcurCorr", &m_sigmaVis_errBeamcurCorr);
   BookParameter("sigmaVis_errBeamcurUncorr_PVtight", &m_sigmaVis_errBeamcurUncorr);
}

Double_t GTest::SigmaVis_PVtight::GetTheoryPrediction() 
{ 
   m_mainparam = m_sigmaVis;
   return SigmaVis::GetTheoryPrediction();
}
